﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;

namespace LFS_External_Client
{
    public partial class dbProcess
    {
        static public string dbServer = "database IP";
        static public string dbPort = "database PORT | default: 3306";
        static public string dbUser = "database USER";
        static public string dbPass = "database PASS";
        static public string dbDatabase = "database DATABASE";

        static public bool dbConnectCheck()
        {
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                try
                {
                    dbConnection.Close();
                }
                catch
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7Database connection couldn't be closed!");
                }
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                }
                return true;
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return false;
            }
        }

        static public bool userExists(string Username)
        {
            #region dbFailurePrecautions
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return false;
            }
            #endregion
            int personalId = 0;
            MySqlCommand cmd = new MySqlCommand("SELECT id FROM osr_users WHERE LOWER(username) = LOWER('" + Username + "')", dbConnection);
            try
            {
                cmd.Prepare();
                MySqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    personalId = reader.GetInt32("id");
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UEX", "SQL(UEX)", ("Username = " + Username + "|personalId = " + personalId).Split('|'), Username);
            }
            dbConnection.Close();

            if (personalId > 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        static public bool userRegister(clsConnection C)
        {
            #region dbFailurePrecautions
            if (globalVars.dbBlockOutgoing == true)
            {
                return false;
            }
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                    dbConnection.Close();
                    return false;
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return false;
            }
            #endregion
            MySqlCommand cmd = new MySqlCommand("INSERT INTO osr_users (username, nickname, webkey, firstseen, lastseen) VALUES ('" + C.Username + "', '" + C.PlayerName + "', '" + C.Username.GetHashCode() + "', '" + DateTime.Now.ToBinary() + "', '" + DateTime.Now.ToBinary() + "')", dbConnection);
            try
            {
                cmd.ExecuteNonQuery();
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-URG", "SQL(URG)", ("Username = " + C.Username + "|Nickname = " + C.PlayerName + "|DateTime = " + DateTime.Now.ToBinary()).Split('|'), C.Username);
                dbConnection.Close();
                return false;
            }
            dbConnection.Close();
            return true;
        }

        static public bool userUpdateStats(clsConnection C)
        {
            #region dbFailurePrecautions
            if (globalVars.dbBlockOutgoing == true)
            {
                return false;
            }
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                    dbConnection.Close();
                    return false;
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return false;
            }
            #endregion
            MySqlCommand cmd = new MySqlCommand("UPDATE osr_users SET " +
                "nickname='" + C.PlayerName + "', " +
                "acc_pass='" + C.accPass + "', " +
                "acc_masterpass='" + C.accMasterPass + "', " +
                "acc_loggedtill='" + C.accLoggedTill + "', " +
                "team_id='" + C.teamId + "', " +
                "team_numb='" + C.teamNumber + "', " +
                "team_rank='" + C.teamRank + "', " +
                "team_rank_custom='" + C.teamRankCustom.ToString() + "', " +
                "team_rights='" + C.teamRights + "', " +
                "country_id='" + C.countryId + "', " +
                "name='" + C.name + "', " +
                "gender='" + C.gender + "', " +
                "birth_date='" + C.birthDate + "', " +
                "email='" + C.email + "', " +
                "email_hide='" + C.emailHide + "', " +
                "rank='" + C.rank + "', " +
                "rank_custom='" + C.rankCustom.ToString() + "', " +
                "rights='" + C.rights + "', " +
                "max_wins_row='" + C.maxWinsInARow + "', " +
                "points_bronze='" + C.pointsBronze + "', " +
                "points_silver='" + C.pointsSilver + "', " +
                "points_gold='" + C.pointsGold + "', " +
                "points_platinum='" + C.pointsPlatinum + "', " +
                "points_global='" + C.pointsGlobal + "', " +
                "races_sum='" + C.racesSum + "', " +
                "races_won='" + C.racesWon + "', " +
                "races_2nd='" + C.racesSecond + "', " +
                "races_3rd='" + C.racesThird + "', " +
                "races_unfin='" + C.racesUnfinished + "', " +
                "laps_fastest='" + C.lapsFastest + "', " +
                "laps_sum='" + C.lapsSum + "', " +
                "pitlane_enter_sum='" + C.pitlaneEnterSum + "', " +
                "pitlane_dt_sum='" + C.pitlaneDtSum + "', " +
                "pitlane_sg_sum='" + C.pitlaneSgSum + "', " +
                "pitlane_nopurp_sum='" + C.pitlaneNoPurposeSum + "', " +
                "pitlane_num_sum='" + C.pitlaneNumSum + "', " +
                "pitstops_sum='" + C.pitstopsSum + "', " +
                "spec_sum='" + C.specSum + "', " +
                "pen_sum='" + C.penSum + "', " +
                "pen_from0_sum='" + C.penFromBlankSum + "', " +
                "pen_admin_sum='" + C.penFromAdminSum + "', " +
                "pen_admin_from0_sum='" + C.penFromAdminFromBlankSum + "', " +
                "pen_fstart_sum='" + C.penFalseStartSum + "', " +
                "pen_fstart_from0_sum='" + C.penFalseStartFromBlankSum + "', " +
                "pen_speeding_sum='" + C.penSpeedingSum + "', " +
                "pen_speeding_from0_sum='" + C.penSpeedingFromBlankSum + "', " +
                "pen_stoplate_sum='" + C.penPitStopTooLateSum + "', " +
                "pen_stoplate_from0_sum='" + C.penPitStopTooLateFromBlankSum + "', " +
                "pen_stopshort_sum='" + C.penPitStopTooShortSum + "', " +
                "pen_stopshort_from0_sum='" + C.penSpeedingFromBlankSum + "', " +
                "pen_wway_sum='" + C.penWrongWaySum + "', " +
                "pen_wway_from0_sum='" + C.penWrongWayFromBlankSum + "', " +
                "pen_unknown_sum='" + C.penUnknownSum + "', " +
                "pen_num_sum='" + C.penNumSum + "', " +
                "blacks_sum='" + C.flagBlacksSum + "', " +
                "yellows_sum='" + C.flagYellowsSum + "', " +
                "lastseen='" + DateTime.Now.ToBinary() + "'" +
                "WHERE id='" + C.personalId + "'", dbConnection);

            try
            {
                cmd.ExecuteNonQuery();
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UUS", "SQL(UUS)", ("UserName = " + C.Username + "|NickName = " + C.PlayerName + "|DateTime = " + DateTime.Now.ToBinary()).Split('|'), C.Username);
                dbConnection.Close();
                C.statsLoadedSuccessfully = false;
                return false;
            }
            dbConnection.Close();
            return true;
        }

        static public bool userGetStats(clsConnection C)
        {
            #region dbFailurePrecautions
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                    dbConnection.Close();
                    return false;
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return false;
            }
            #endregion

            MySqlCommand cmd = new MySqlCommand("SELECT * FROM osr_users WHERE LOWER(username) = LOWER('" + C.Username + "')", dbConnection);
            try
            {
                cmd.Prepare();
                MySqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    C.personalId = reader.GetInt32("id");
                    C.accPass = reader.GetString("acc_pass");
                    C.accLoggedTill = reader.GetString("acc_loggedtill");
                    C.accMasterPass = reader.GetString("acc_masterpass");
                    C.teamId = reader.GetInt32("team_id");
                    C.teamNumber = reader.GetInt32("team_numb");
                    C.teamRank = reader.GetString("team_rank");
                    C.teamRankCustom = reader.GetBoolean("team_rank_custom");
                    C.teamRights = reader.GetString("team_rights");
                    C.countryId = reader.GetInt32("country_id");
                    C.name = reader.GetString("name");
                    C.gender = reader.GetString("gender");
                    C.birthDate = reader.GetString("birth_date");
                    C.email = reader.GetString("email");
                    C.emailHide = reader.GetBoolean("email_hide");
                    C.rank = reader.GetString("rank");
                    C.rankCustom = reader.GetBoolean("rank_custom");
                    C.rights = reader.GetString("rights");
                    C.maxWinsInARow = reader.GetInt32("max_wins_row");
                    C.pointsBronze = reader.GetInt32("points_bronze");
                    C.pointsSilver = reader.GetInt32("points_silver");
                    C.pointsGold = reader.GetInt32("points_gold");
                    C.pointsPlatinum = reader.GetInt32("points_platinum");
                    C.pointsGlobal = reader.GetInt32("points_global");
                    C.racesSum = reader.GetInt32("races_sum");
                    C.racesWon = reader.GetInt32("races_won");
                    C.racesSecond = reader.GetInt32("races_2nd");
                    C.racesThird = reader.GetInt32("races_3rd");
                    C.racesUnfinished = reader.GetInt32("races_unfin");
                    C.lapsSum = reader.GetInt32("laps_sum");
                    C.lapsFastest = reader.GetInt32("laps_fastest");
                    C.pitlaneEnterSum = reader.GetInt32("pitlane_enter_sum");
                    C.pitlaneDtSum = reader.GetInt32("pitlane_dt_sum");
                    C.pitlaneSgSum = reader.GetInt32("pitlane_sg_sum");
                    C.pitlaneNoPurposeSum = reader.GetInt32("pitlane_nopurp_sum");
                    C.pitlaneNumSum = reader.GetInt32("pitlane_num_sum");
                    C.pitstopsSum = reader.GetInt32("pitstops_sum");
                    C.specSum = reader.GetInt32("spec_sum");
                    C.penSum = reader.GetInt32("pen_sum");
                    C.penFromBlankSum = reader.GetInt32("pen_from0_sum");
                    C.penFromAdminSum = reader.GetInt32("pen_admin_sum");
                    C.penFromAdminFromBlankSum = reader.GetInt32("pen_admin_from0_sum");
                    C.penFalseStartSum = reader.GetInt32("pen_fstart_sum");
                    C.penFalseStartFromBlankSum = reader.GetInt32("pen_fstart_from0_sum");
                    C.penSpeedingSum = reader.GetInt32("pen_speeding_sum");
                    C.penSpeedingFromBlankSum = reader.GetInt32("pen_speeding_from0_sum");
                    C.penPitStopTooLateSum = reader.GetInt32("pen_stoplate_sum");
                    C.penPitStopTooLateFromBlankSum = reader.GetInt32("pen_stoplate_from0_sum");
                    C.penPitStopTooShortSum = reader.GetInt32("pen_stopshort_sum");
                    C.penPitStopTooShortFromBlankSum = reader.GetInt32("pen_stopshort_from0_sum");
                    C.penWrongWaySum = reader.GetInt32("pen_wway_sum");
                    C.penWrongWayFromBlankSum = reader.GetInt32("pen_wway_from0_sum");
                    C.penUnknownSum = reader.GetInt32("pen_unknown_sum");
                    C.penNumSum = reader.GetInt32("pen_num_sum");
                    C.flagBlacksSum = reader.GetInt32("blacks_sum");
                    C.flagYellowsSum = reader.GetInt32("yellows_sum");
                    C.webKey = reader.GetString("webkey");
                    C.firstSeen = reader.GetString("firstseen");
                    C.lastSeen = reader.GetString("lastseen");
                    C.statsLoadedSuccessfully = true;
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UGS", "SQL(UGS)", ("UserName = " + C.Username+ "|NickName = " + C.PlayerName + "|DateTime = " + DateTime.Now.ToBinary()).Split('|'), C.Username);
                dbConnection.Close();
                C.statsLoadedSuccessfully = false;
                return false;
            }
            dbConnection.Close();
            return true;
        }

        static public bool userAddStats(clsConnection C)
        {
            #region dbFailurePrecautions
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                    dbConnection.Close();
                    return false;
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return false;
            }
            #endregion
            MySqlCommand cmd = new MySqlCommand("SELECT * FROM osr_users WHERE LOWER(username) = LOWER('" + C.Username + "')", dbConnection);
            try
            {
                cmd.Prepare();
                MySqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    C.personalId = reader.GetInt32("id");
                    C.accPass = reader.GetString("acc_pass");
                    C.accLoggedTill = reader.GetString("acc_loggedtill");
                    C.accMasterPass = reader.GetString("acc_masterpass");
                    C.teamId = reader.GetInt32("team_id");
                    C.teamNumber = reader.GetInt32("team_numb");
                    C.teamRank = reader.GetString("team_rank");
                    C.teamRankCustom = reader.GetBoolean("team_rank_custom");
                    C.teamRights = reader.GetString("team_rights");
                    C.countryId = reader.GetInt32("country_id");
                    C.name = reader.GetString("name");
                    C.gender = reader.GetString("gender");
                    C.birthDate = reader.GetString("birth_date");
                    C.email = reader.GetString("email");
                    C.emailHide = reader.GetBoolean("email_hide");
                    C.rank = reader.GetString("rank");
                    C.rankCustom = reader.GetBoolean("rank_custom");
                    C.rights = reader.GetString("rights");
                    C.maxWinsInARow = reader.GetInt32("max_wins_row");
                    C.pointsBronze += reader.GetInt32("points_bronze");
                    C.pointsSilver += reader.GetInt32("points_silver");
                    C.pointsGold += reader.GetInt32("points_gold");
                    C.pointsPlatinum += reader.GetInt32("points_platinum");
                    C.pointsGlobal += reader.GetInt32("points_global");
                    C.racesSum += reader.GetInt32("races_sum");
                    C.racesWon += reader.GetInt32("races_won");
                    C.racesSecond += reader.GetInt32("races_2nd");
                    C.racesThird += reader.GetInt32("races_3rd");
                    C.racesUnfinished += reader.GetInt32("races_unfin");
                    C.lapsSum += reader.GetInt32("laps_sum");
                    C.lapsFastest += reader.GetInt32("laps_fastest");
                    C.pitlaneEnterSum += reader.GetInt32("pitlane_enter_sum");
                    C.pitlaneDtSum += reader.GetInt32("pitlane_dt_sum");
                    C.pitlaneSgSum += reader.GetInt32("pitlane_sg_sum");
                    C.pitlaneNoPurposeSum += reader.GetInt32("pitlane_nopurp_sum");
                    C.pitlaneNumSum += reader.GetInt32("pitlane_num_sum");
                    C.pitstopsSum += reader.GetInt32("pitstops_sum");
                    C.specSum += reader.GetInt32("spec_sum");
                    C.penSum += reader.GetInt32("pen_sum");
                    C.penFromBlankSum += reader.GetInt32("pen_from0_sum");
                    C.penFromAdminSum += reader.GetInt32("pen_admin_sum");
                    C.penFromAdminFromBlankSum += reader.GetInt32("pen_admin_from0_sum");
                    C.penFalseStartSum += reader.GetInt32("pen_fstart_sum");
                    C.penFalseStartFromBlankSum += reader.GetInt32("pen_fstart_from0_sum");
                    C.penSpeedingSum += reader.GetInt32("pen_speeding_sum");
                    C.penSpeedingFromBlankSum += reader.GetInt32("pen_speeding_from0_sum");
                    C.penPitStopTooLateSum += reader.GetInt32("pen_stoplate_sum");
                    C.penPitStopTooLateFromBlankSum += reader.GetInt32("pen_stoplate_from0_sum");
                    C.penPitStopTooShortSum += reader.GetInt32("pen_stopshort_sum");
                    C.penPitStopTooShortFromBlankSum += reader.GetInt32("pen_stopshort_from0_sum");
                    C.penWrongWaySum += reader.GetInt32("pen_wway_sum");
                    C.penWrongWayFromBlankSum += reader.GetInt32("pen_wway_from0_sum");
                    C.penUnknownSum += reader.GetInt32("pen_unknown_sum");
                    C.penNumSum += reader.GetInt32("pen_num_sum");
                    C.flagBlacksSum += reader.GetInt32("blacks_sum");
                    C.flagYellowsSum += reader.GetInt32("yellows_sum");
                    C.webKey = reader.GetString("webkey");
                    C.firstSeen = reader.GetString("firstseen");
                    C.lastSeen = reader.GetString("lastseen");
                    C.statsLoadedSuccessfully = true;
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UGS", "SQL(UGS)", ("UserName = " + C.Username + "|NickName = " + C.PlayerName + "|DateTime = " + DateTime.Now.ToBinary()).Split('|'), C.Username);
                dbConnection.Close();
                return false;
            }
            dbConnection.Close();
            return true;
        }

        static public globalStructs.topTenStrings getTopTenStringsBy(string orderBy)
        {
            globalStructs.topTenStrings top10 = new globalStructs.topTenStrings();
            #region dbFailurePrecautions
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return new globalStructs.topTenStrings();
            }
            #endregion
            int topCounter = 1;
            MySqlCommand cmd = new MySqlCommand("SELECT `username`, `nickname`, `" + orderBy + "` FROM `osr_users` ORDER BY `" + orderBy + "` DESC LIMIT 10", dbConnection);
            try
            {
                cmd.Prepare();
                MySqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    string stringSet = "^7. " + reader.GetString("nickname") + " ^7- ^2" + reader.GetString(orderBy) + "^7pts.";
                    //for (int i = 0; i < Form1.Connections.Count; i++)
                    //{
                    //    if (Form1.Connections[i].Username == reader.GetString("username"))
                    //    {
                    //        switch (orderBy)
                    //        {
                    //            case "points_bronze":
                    //                stringSet = "^7. " + Form1.Connections[i].PlayerName + " ^7(" + Form1.Connections[i].Username + "^7) - ^2" + Form1.Connections[i].pointsBronze + "^7pts.";
                    //                break;

                    //            case "points_silver":
                    //                stringSet = "^7. " + Form1.Connections[i].PlayerName + " ^7(" + Form1.Connections[i].Username + "^7) - ^2" + Form1.Connections[i].pointsSilver + "^7pts.";
                    //                break;

                    //            case "points_gold":
                    //                stringSet = "^7. " + Form1.Connections[i].PlayerName + " ^7(" + Form1.Connections[i].Username + "^7) - ^2" + Form1.Connections[i].pointsGold + "^7pts.";
                    //                break;

                    //            case "points_platinum":
                    //                stringSet = "^7. " + Form1.Connections[i].PlayerName + " ^7(" + Form1.Connections[i].Username + "^7) - ^2" + Form1.Connections[i].pointsPlatinum + "^7pts.";
                    //                break;

                    //            case "points_global":
                    //                stringSet = "^7. " + Form1.Connections[i].PlayerName + " ^7(" + Form1.Connections[i].Username + "^7) - ^2" + Form1.Connections[i].pointsGlobal + "^7pts.";
                    //                break;
                    //        }
                    //    }
                    //}

                    switch (topCounter)
                    {
                        case 1:
                            top10.top1 = "^21" + stringSet;
                            break;

                        case 2:
                            top10.top2 = "^22" + stringSet;
                            break;

                        case 3:
                            top10.top3 = "^23" + stringSet;
                            break;

                        case 4:
                            top10.top4 = "^24" + stringSet;
                            break;

                        case 5:
                            top10.top5 = "^25" + stringSet;
                            break;

                        case 6:
                            top10.top6 = "^26" + stringSet;
                            break;

                        case 7:
                            top10.top7 = "^27" + stringSet;
                            break;

                        case 8:
                            top10.top8 = "^28" + stringSet;
                            break;

                        case 9:
                            top10.top9 = "^29" + stringSet;
                            break;

                        case 10:
                            top10.top10 = "^210" + stringSet;
                            break;
                    }
                    topCounter += 1;
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UEX", "SQL(UEX)", ("orderBy = " + orderBy + "|topCounter = " + topCounter).Split('|'), "/globalError");
            }
            dbConnection.Close();

            return top10;
        }

        static public globalStructs.userGetRank userGetRank(string Username)
        {
            globalStructs.userGetRank rankStruct = new globalStructs.userGetRank();
            #region dbFailurePrecautions
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return new globalStructs.userGetRank();
            }
            #endregion
            int rank = 0;
            MySqlCommand cmd = new MySqlCommand("SELECT t.id, t.nickname, t.points_bronze, t.points_silver, t.username, (" +
                                                "SELECT COUNT(id) + 1 " +
                                                "FROM `osr_users` " +
                                                "WHERE points_bronze > t.points_bronze) " +
                                                "AS rank " +
                                                "FROM `osr_users` AS t " +
                                                "WHERE LOWER(t.username) = LOWER('" + Username + "')", dbConnection);
            try
            {
                cmd.Prepare();
                MySqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    rankStruct.nickname = reader.GetString("nickname");
                    rankStruct.rank = reader.GetInt32("rank");
                    rankStruct.pointsBronze = reader.GetInt32("points_bronze");
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UGR", "SQL(UGR)", ("Username = " + Username + "|rank = " + rank).Split('|'), Username);
            }
            dbConnection.Close();

            return rankStruct;
        }

        static public int usersTotal()
        {
            #region dbFailurePrecautions
            string dbConnInfo = "server=" + dbServer + ";userid=" + dbUser + ";password=" + dbPass + ";database=" + dbDatabase;
            MySqlConnection dbConnection = new MySqlConnection(dbConnInfo);
            try
            {
                dbConnection.Open(); // connection must be openned for command
                if (globalVars.dbCanConnect == false)
                {
                    globalVars.dbBlockOutgoing = true;
                    globalVars.dbCanConnect = true;
                    Form1.InSim.Send_MST_Message("/msg ^8» ^3Attention: ^7Database opened successfully!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1All outgoing database connections blocked!");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^7Synchronizing users' stats with database!");
                    try
                    {
                        Form1.InSim.Request_NCN_AllConnections(30);
                        globalVars.dbBlockOutgoing = false;
                    }
                    catch
                    {
                        Form1.InSim.Send_MST_Message("/msg ^8» ^1Error: ^7C. list was not be rebuilt!");
                    }
                }
            }
            catch
            {
                if (globalVars.dbCanConnect == true)
                {
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Critical error: ^7Database could not be open.");
                    Form1.InSim.Send_MST_Message("/msg ^8» ^1Warning: ^7Stats system not available.");
                    globalVars.dbCanConnect = false;
                }
                return 0;
            }
            #endregion
            int usersTotal = 0;
            MySqlCommand cmd = new MySqlCommand("SELECT id FROM osr_users ORDER BY id DESC LIMIT 1", dbConnection);
            try
            {
                cmd.Prepare();
                MySqlDataReader reader = cmd.ExecuteReader();
                while (reader.Read())
                {
                    usersTotal = reader.GetInt32("id");
                }
            }
            catch (Exception E)
            {
                misc.buildErrorReportOnCrash(E, "SQL-UGT", "SQL(UGT)", ("usersTotal = " + usersTotal).Split('|'), "/globalError");
            }
            dbConnection.Close();

            return usersTotal;
        }
    }
}